
module RPG


  class EventCommand
    def initialize(code = 0, indent = 0, parameters = [])
      @code = code
      @indent = indent
      @parameters = parameters
    end
    attr_accessor :code
    attr_accessor :indent
    attr_accessor :parameters
  end



  class EventCommand

    include DMK_Constants

    ##########################################
    # Fonctions utilises
    ##########################################


    # Transforme une commande en son quivalent DMK
    # Fais appel  des sous classes des commandes DMK pour amliorer les
    # traitements
    def to_dmk
      case @code
      when CODE_MESSAGE # 101 : Message
        return My_RPG::My_Command_Message.from_rmxp(self)
      when CODE_SLOT # 102 : Slot Choice
        return My_RPG::My_Command_Slot.from_rmxp(self)
      when CODE_COMMENTARY # 108 : Commentaire
        return My_RPG::My_Command_Commentary.from_rmxp(self)
      when CODE_VARIABLE # 122 : Affectation de variable
        return My_RPG::My_Command_Variable.from_rmxp(self)
      when CODE_WINDOWSKIN # 131 : Changer l'apparence des fentres
        return My_RPG::My_Command_Windowskin.from_rmxp(self)
      when CODE_CHANGE_MUSIC_BATTLE # 132 : Changer la musique des combats
        return My_RPG::My_Command_Change_Music_Battle.from_rmxp(self)
      when CODE_CHANGE_MUSIC_VICTORY # 133 : Changer la musique de victoire
        return My_RPG::My_Command_Change_Music_Victory.from_rmxp(self)
      when CODE_TRANSITION # 222 : Excuter la transition
        return My_RPG::My_Command_Transition.from_rmxp(self)
      when CODE_PROPRIETE_MAP # 204 : Proprits de la carte
        return My_RPG::My_Command_Propriete_Carte.from_rmxp(self)
      when CODE_PICTURE_SHOW # 231 : Afficher une image
        return My_RPG::My_Command_Afficher_Image.from_rmxp(self)
      when CODE_BGM_PLAY # 241 : Jouer un fond musical (BGM)
        return My_RPG::My_Command_BGM.from_rmxp(self)
      when CODE_BGS_PLAY # 245 : Jouer un fond sonore (BGS)
        return My_RPG::My_Command_BGS.from_rmxp(self)
      when CODE_ME_PLAY # 249 : Jouer un effet musical (ME)
        return My_RPG::My_Command_ME.from_rmxp(self)
      when CODE_MOVE_EVENT # 209 : Dplacer l'vnement
        # Cette instruction est compose de toute une liste de
        # sous-instructions
        my = My_RPG::My_Parcours.from_rmxp(self)
        return my
      when CODE_SE_PLAY # 250 : Jouer un effet sonore (SE)
        return My_RPG::My_Command_SE.from_rmxp(self)
      when CODE_MESSAGE_SUITE # 401 : suite de Message
        return My_RPG::My_Command_Message_Suite.from_rmxp(self)
      when CODE_SLOT_SUITE # 402 : suite de Slot Choice
        return My_RPG::My_Command_Slot_Suite.from_rmxp(self)
      when CODE_COMMENTARY_SUITE # 408 : suite de Commentary
        return My_RPG::My_Command_Commentary_Suite.from_rmxp(self)
        
      when CODE_MOVE_EVENT_SUITE # 509 : Sous-commande de Dplacer l'vnement
        #my = My_RPG::My_Parcours_Suite.from_rmxp(self)
        my = nil
        return my
      else
        my = My_RPG::My_EventCommand.from_rmxp(self)
        return my
      end

    end

    
    def comparer(command)
      if @code != command.code
        #p @code, command.code
        #getz

        raise(DMKW_DMK_Diff.new("command.code"))
      end
      if self.indent != command.indent
        #pa @indent, command.indent
        raise(DMKW_DMK_Diff.new("command.indent"))
      end
      case @code
      when CODE_MOVE_EVENT_SUITE # 509
        @parameters[0].comparer(command.parameters[0])
      when CODE_MOVE_EVENT # 209
        # Cas de move event
        # On ne compare pas les commandes internes car elles seront compares
        # par la suite (code 509)
      when CODE_BGM_PLAY, CODE_SE_PLAY, CODE_BGS_PLAY, CODE_CHANGE_MUSIC_BATTLE, CODE_CHANGE_MUSIC_VICTORY
        @parameters[0].comparer(command.parameters[0])
      else
        #return false
        if @parameters != command.parameters
        #p self
          
          p @parameters, command.parameters

          #p @parameters[0].comparer(command.parameters[0])
          raise(DMKW_DMK_Diff.new("Event command.parameters"))
        end
      end
      return true
    end



    def inspect2
      txt = "#{self.class} code:#{@code} indent:#{self.indent} parameters:(#{@parameters.join(" ; ")})"
      return txt
    end



  end

end
  